IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_DESCONTOS_APLICAR_VENDAS_EXEC_ALL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_DESCONTOS_APLICAR_VENDAS_EXEC_ALL] 

go
Create procedure P_EST_PROD_DESCONTOS_APLICAR_VENDAS_EXEC_ALL
AS

	DECLARE @cd_chave_FILIAL int,
			@DataIni date , @DataFim date;
							
	set @DataIni =getdate()-3; 
	set @DataFim = getdate();

	declare c_Chave CURSOR FAST_FORWARD FOR
	SELECT CD_FILIAL  
		FROM PRC_FILIAL 
		ORDER BY CD_FILIAL
	
	
	OPEN c_Chave
	FETCH NEXT FROM c_Chave INTO @cd_chave_FILIAL
	WHILE @@FETCH_STATUS = 0
		BEGIN
			PRINT 'Procesando lj ' + CONVERT(VARCHAR, @cd_chave_FILIAL)				 
			EXEC P_EST_PROD_DESCONTOS_APLICAR_VENDAS 1,@cd_chave_FILIAL ,@DataIni,@DataFim;

			FETCH NEXT FROM c_Chave INTO @cd_chave_FILIAL
		END
	CLOSE c_Chave;
	DEALLOCATE c_Chave;